<?php
$step = $_GET['step'] ?? 1;
$error = '';
$success = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if ($step == 1) {
        // Database Configuration
        $db_host = $_POST['db_host'];
        $db_name = $_POST['db_name'];
        $db_user = $_POST['db_user'];
        $db_pass = $_POST['db_pass'];

        try {
            $pdo = new PDO("mysql:host=$db_host", $db_user, $db_pass);
            $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
            
            // Create database if not exists
            $pdo->exec("CREATE DATABASE IF NOT EXISTS `$db_name` CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci");
            $pdo->exec("USE `$db_name` text");

            // Import schema
            $sql = file_get_contents(BASE_PATH . '/database/schema.sql');
            $pdo->exec($sql);

            // Save to .env
            $env_content = "APP_NAME=\"Ya Ticky\"\n";
            $env_content .= "APP_ENV=development\n";
            $env_content .= "APP_DEBUG=true\n";
            $env_content .= "APP_URL=\"http://localhost\"\n\n";
            $env_content .= "DB_HOST=\"$db_host\"\n";
            $env_content .= "DB_NAME=\"$db_name\"\n";
            $env_content .= "DB_USER=\"$db_user\"\n";
            $env_content .= "DB_PASSWORD=\"$db_pass\"\n";
            
            file_put_contents(BASE_PATH . '/.env', $env_content);
            
            header('Location: /install?step=2');
            exit;
        } catch (PDOException $e) {
            $error = "Database Connection Failed: " . $e->getMessage();
        }
    } elseif ($step == 2) {
        // Admin Credentials
        $admin_email = $_POST['admin_email'];
        $admin_pass = $_POST['admin_pass'];
        
        if (strlen($admin_pass) < 8) {
            $error = "Password must be at least 8 characters.";
        } else {
            try {
                $pdo = new PDO("mysql:host=" . DB_HOST . ";dbname=" . DB_NAME, DB_USER, DB_PASSWORD);
                $hash = password_hash($admin_pass, PASSWORD_BCRYPT, ['cost' => 12]);
                
                $stmt = $pdo->prepare("INSERT INTO users (email, password_hash, role) VALUES (?, ?, 'admin')");
                $stmt->execute([$admin_email, $hash]);
                
                $success = "Installation Complete! You can now login.";
                // Optionally delete install file or mark as installed
                file_put_contents(BASE_PATH . '/installed.txt', date('Y-m-d H:i:s'));
            } catch (PDOException $e) {
                $error = "Failed to create admin: " . $e->getMessage();
            }
        }
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Ya Ticky - Installer</title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gray-100 flex items-center justify-center min-h-screen">
    <div class="bg-white p-8 rounded-lg shadow-md w-full max-w-md">
        <h1 class="text-2xl font-bold mb-6 text-center">Ya Ticky Installation</h1>
        
        <?php if ($error): ?>
            <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded mb-4"><?php echo $error; ?></div>
        <?php endif; ?>
        
        <?php if ($success): ?>
            <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded mb-4">
                <?php echo $success; ?>
                <div class="mt-2"><a href="/login" class="text-blue-600 font-bold">Go to Login</a></div>
            </div>
        <?php else: ?>
            
            <?php if ($step == 1): ?>
                <form method="POST">
                    <div class="mb-4">
                        <label class="block text-gray-700">Database Host</label>
                        <input type="text" name="db_host" value="localhost" class="w-full px-3 py-2 border rounded" required>
                    </div>
                    <div class="mb-4">
                        <label class="block text-gray-700">Database Name</label>
                        <input type="text" name="db_name" value="ya_ticky" class="w-full px-3 py-2 border rounded" required>
                    </div>
                    <div class="mb-4">
                        <label class="block text-gray-700">Database User</label>
                        <input type="text" name="db_user" value="root" class="w-full px-3 py-2 border rounded" required>
                    </div>
                    <div class="mb-4">
                        <label class="block text-gray-700">Database Password</label>
                        <input type="password" name="db_pass" class="w-full px-3 py-2 border rounded">
                    </div>
                    <button type="submit" class="w-full bg-blue-600 text-white py-2 rounded hover:bg-blue-700">Next: Setup Admin</button>
                </form>
            <?php elseif ($step == 2): ?>
                <form method="POST">
                    <div class="mb-4">
                        <label class="block text-gray-700">Admin Email</label>
                        <input type="email" name="admin_email" class="w-full px-3 py-2 border rounded" required>
                    </div>
                    <div class="mb-4">
                        <label class="block text-gray-700">Admin Password</label>
                        <input type="password" name="admin_pass" class="w-full px-3 py-2 border rounded" required minlength="8">
                    </div>
                    <button type="submit" class="w-full bg-green-600 text-white py-2 rounded hover:bg-green-700">Complete Installation</button>
                </form>
            <?php endif; ?>
            
        <?php endif; ?>
    </div>
</body>
</html>
