<?php
if (!isset($_SESSION['user_id'])) {
    header('Location: /login');
    exit;
}

try {
    $pdo = new PDO("mysql:host=" . DB_HOST . ";dbname=" . DB_NAME, DB_USER, DB_PASSWORD);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    $stmt = $pdo->prepare("SELECT * FROM users WHERE id = ?");
    $stmt->execute([$_SESSION['user_id']]);
    $user = $stmt->fetch(PDO::FETCH_ASSOC);

    // Get available tasks
    $tasks = $pdo->query("SELECT * FROM tasks WHERE is_active = 1 LIMIT 5")->fetchAll(PDO::FETCH_ASSOC);
} catch (PDOException $e) {
    $error = "Database error: " . $e->getMessage();
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Ya Ticky - Dashboard</title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gray-100">
    <nav class="bg-white shadow-sm px-6 py-4 flex justify-between items-center">
        <h1 class="text-xl font-bold text-blue-600">Ya Ticky</h1>
        <div class="flex items-center gap-4">
            <div class="bg-yellow-100 text-yellow-800 px-3 py-1 rounded-full text-sm font-bold">
                Coins: <?php echo number_format($user['coin_balance'], 2); ?>
            </div>
            <span class="text-gray-600"><?php echo htmlspecialchars($user['email']); ?></span>
            <a href="/logout" class="text-red-500 hover:underline">Logout</a>
        </div>
    </nav>

    <div class="p-8 max-w-4xl mx-auto">
        <h2 class="text-2xl font-semibold mb-6">Available Tasks</h2>
        
        <?php if (empty($tasks)): ?>
            <div class="bg-white p-8 rounded-lg shadow-sm text-center text-gray-500">
                No tasks available at the moment. Check back later!
            </div>
        <?php else: ?>
            <div class="grid gap-4">
                <?php foreach ($tasks as $task): ?>
                    <div class="bg-white p-6 rounded-lg shadow-sm flex justify-between items-center">
                        <div>
                            <h3 class="font-bold text-lg"><?php echo htmlspecialchars($task['title']); ?></h3>
                            <p class="text-gray-600 text-sm"><?php echo htmlspecialchars($task['description']); ?></p>
                        </div>
                        <div class="text-right">
                            <div class="text-green-600 font-bold">+<?php echo $task['reward_coins']; ?> Coins</div>
                            <button class="mt-2 bg-blue-600 text-white px-4 py-1 rounded text-sm hover:bg-blue-700">Start Task</button>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        <?php endif; ?>
    </div>
</body>
</html>
