<?php
// Check if user is admin
if (!isset($_SESSION['user_role']) || $_SESSION['user_role'] !== 'admin') {
    header('Location: /login');
    exit;
}

try {
    $pdo = new PDO("mysql:host=" . DB_HOST . ";dbname=" . DB_NAME, DB_USER, DB_PASSWORD);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    // Get some stats
    $user_count = $pdo->query("SELECT COUNT(*) FROM users")->fetchColumn();
    $task_count = $pdo->query("SELECT COUNT(*) FROM tasks")->fetchColumn();
    $deposit_count = $pdo->query("SELECT COUNT(*) FROM deposit_requests WHERE status = 'pending'")->fetchColumn();
} catch (PDOException $e) {
    $error = "Database error: " . $e->getMessage();
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Ya Ticky - Admin Dashboard</title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gray-100">
    <nav class="bg-white shadow-sm px-6 py-4 flex justify-between items-center">
        <h1 class="text-xl font-bold text-blue-600">Ya Ticky Admin</h1>
        <div class="flex items-center gap-4">
            <span class="text-gray-600"><?php echo htmlspecialchars($_SESSION['user_email']); ?></span>
            <a href="/logout" class="text-red-500 hover:underline">Logout</a>
        </div>
    </nav>

    <div class="p-8 max-w-6xl mx-auto">
        <h2 class="text-2xl font-semibold mb-6">Dashboard Overview</h2>
        
        <div class="grid grid-cols-1 md:grid-cols-3 gap-6 mb-8">
            <div class="bg-white p-6 rounded-lg shadow-sm border-l-4 border-blue-500">
                <div class="text-gray-500 text-sm uppercase font-bold">Total Users</div>
                <div class="text-3xl font-bold"><?php echo $user_count ?? 0; ?></div>
            </div>
            <div class="bg-white p-6 rounded-lg shadow-sm border-l-4 border-green-500">
                <div class="text-gray-500 text-sm uppercase font-bold">Active Tasks</div>
                <div class="text-3xl font-bold"><?php echo $task_count ?? 0; ?></div>
            </div>
            <div class="bg-white p-6 rounded-lg shadow-sm border-l-4 border-yellow-500">
                <div class="text-gray-500 text-sm uppercase font-bold">Pending Deposits</div>
                <div class="text-3xl font-bold"><?php echo $deposit_count ?? 0; ?></div>
            </div>
        </div>

        <div class="bg-white rounded-lg shadow-sm p-6">
            <h3 class="text-lg font-bold mb-4">Quick Actions</h3>
            <div class="flex gap-4">
                <button class="bg-blue-600 text-white px-4 py-2 rounded hover:bg-blue-700">Create New Task</button>
                <button class="bg-gray-200 text-gray-800 px-4 py-2 rounded hover:bg-gray-300">Manage Users</button>
                <button class="bg-gray-200 text-gray-800 px-4 py-2 rounded hover:bg-gray-300">Review Deposits</button>
            </div>
        </div>
    </div>
</body>
</html>
